[**Oklahoma NG911 Toolkit**](README.html) | [Prep] | [Enhancement] | [Validation] | [MSAG] | [Comparison] | [Submission]

**Supplementary Documentation** | [Examples] | [Topology Rules] | [Change Log] | [Error Glossary] | [API]

# Oklahoma Next-Generation 9-1-1 Pro Toolkit

[![Logo2](Doc/img/Logo2.png)](Doc/img/Logo2.png)

## Abstract

The original NG911 Toolkit was adapted from the [Kansas NG911 Toolkit]. The most recent Oklahoma Next-Generation 9-1-1 Toolkit has been converted from Desktop to Pro. However, the functionality is the same. The Toolkit is a collection of Tools that identify possible errors and assist the user in complying with the NG911 Oklahoma Standards. Currently, the Toolkit includes 3 toolsets: [Prep], [Enhancement], and [Validation]. For specific changes to the Toolkit, see the [Change Log] and other Toolset Docs. The Toolkit can be found on the [Oklahoma Geographic Information Council's standards webpage].

## Getting Started

Unzip the NG911 Pro Toolbox and leave all files and folders in the original structure.

### Requirements

#### ArcGIS

This toolkit requires an installation of ArcGIS Pro 3.3. These tools were tested in ArcGIS Pro 3.3. They may or may not work as expected in other versions of ArcGIS Pro.

#### Python

ArcGIS Pro 3.3 is installed with Python 3.11. The tools may or may not work with other versions of Python. The `arcpy` and `arcgis` packages, included with ArcGIS, are required, as well as an active ArcGIS license. Standard license is required for Topology, and Advanced license is required for Check Road ESN Advanced. Otherwise, a Basic license is required.

#### File and Folder Structure

Maintaining file and folder structure is required for proper operation of the Toolkit.

Required folders/files include (but are not limited to) the following:

* `NG911_GIS_Toolkit.pyt`
* `ng911ok` folder and all within
* `config.yml`
* `topology.yml`
* `legacy.yml`
* `counties.yml`
* Files with names like `NG911_GIS_Toolkit_Pro.<...>.xml`

#### Current Oklahoma NG911 Standards

See the [Oklahoma Geographic Information Council's standards webpage] for the latest versions of the Oklahoma NG911 and Address Standard.

* Current Standards Version: **3.0**

### Python API and Toolkit Configuration Documentation

For information about the Python API behind the Toolkit, see the `API Doc` folder or [click here](<API Doc/index.html>).

For information about the YAML configuration files, see [API Doc/config_yaml.html].

**The API and configuration documentation is not relevant to regular Toolkit usage**, but may be useful for those who wish to write custom NG911-related scripts. Please note that editing the YAML configuration files may cause the tools to behave incorrectly or even break completely.

### Using the Tools

![Flowchart](Doc/img/Flowchart.png)

#### Prep Tools

The [Prep] tools provide the user with an easy way to create a new standards-compliant geodatabase and convert existing data to comply with the schemas set forth in the Oklahoma NG911 Standards. For more information on where to start as a user, see the [Examples] document.

##### Create Empty Geodatabase

![Create GDB Tool](Doc/img/Example_CreateStandardGDB.png)

To create an empty geodatabase, run the [1 Create Standard GDB] tool with a folder location, an output GDB name, a selected coordinate reference system. Leave the feature classes options blank and then 'Run'. The output geodatabase will be in the folder specified and will have a user-specified name. If the user checks the 'Create Blank FC' options, the tool will create an Oklahoma standards-compliant blank feature class when a feature class is not provided **or** when the feature class provided does not match the Oklahoma standards.

##### Field Mapping

![Field Map Tool](Doc/img/Example_ESZFieldMap.png)

To create a feature class that is correctly formatted, use the [2 Field Map Feature Class] tool with the correctly-formatted geodatabase, the user-specified feature class, and the user-specified fields mapped to the appropriate Standard fields. **Triple-check** all user inputs before running the field mapping tool, especially similar fields like `Country` and `County`.

For more information on the individual tools in this toolset, see the [Prep] Toolset Documentation.

#### **Validation Tools**

![Validate Geodatabase](Doc/img/Example_ValidateGeodatabase.png)

**IMPORTANT:** Keep all fields up-to-date, in particular `SUBMIT` and `TopoExcept`. Features where `SUBMIT` is `N` will be omitted entirely from validation checks. Features given a topological exception will be exempted from given [Topology Rules].

The Validate Geodatabase tool in the [Validation] toolset were written to review the NG911 geodatabase data for submission to the NG911 repository using the Oklahoma NG911 Standards.

For more information on the individual tools in this toolset, see the [Validation] Toolset Documentation.

##### Interpreting the Results

This section is pending update.

#### **Enhancement Tools**

The [Enhancement] Tools can be used to automate various tasks involved with data creation and perform quality checks to enhance the data.

##### Marking for Submission using Fix Submit

The [Calculate Null Values to `N`] tool will calculate blank/null values in the `SUBMIT` field to `Y` for all the feature classes in a geodatabase. The user would simply mark the features that are not to be included in the submission with `N` and run the Fix Submit tool.

##### Calculating FullName and LgcyFulSt

The [Calculate `FullName` and `LgcyFulSt`] tool calculates the `FullName` and/or `LgcyFulSt` fields for the Address Point feature class and/or the Road Centerline feature class.

##### Converting from Legacy to Next Generation using Fix Street Type and Direction

The [Convert Type] and [Convert Direction] tools will calculate the [next-gen fields] from [legacy fields] and vice versa.

##### Calculating the Required Fields: RCLMatch and RCLSide

[Calculate `RCLMatch` and `RCLSide`] calculates the required fields `RCLMatch` and `RCLSide` in the Address Point feature class.

For more information on the individual tools in this toolset, see the [Enhancement] Toolset Documentation.

## **Credits**

Scripts written by Riley Baird and Emma Baker with the Oklahoma Transportation Cabinet (OTC)

##### Last Revised:

April 18, 2025

## **Disclaimer**

The Oklahoma NG9-1-1 GIS Toolbox is provided by the Oklahoma Geographic Information (GI) Council, Oklahoma 9-1-1 Management Authority, Oklahoma Department of Transportation (ODOT), Oklahoma Office of Geographic Information (OGI) , and associated contributors "as is" and any express or implied warranties, including, but not limited to, the implied warranties of merchantability and fitness for a particular purpose are disclaimed.  In no event shall the Oklahoma GI Council, Oklahoma 9-1-1 Management Authority, ODOT, OGI, or associated contributors be liable for any direct, indirect, incidental, special, exemplary, or consequential damages (including, but not limited to, procurement of substitute goods or services; loss of use, data, or profits; or business interruption) however caused and on any theory of liability, whether in contract, strict liability, or tort (including negligence or otherwise) arising in any way out of the use of this software, even if advised of the possibility of such damage.

<!-- External Doc links -->
[Prep]: Doc/Prep.html
[Adjustment]: Doc/Adjustment.html
[Comparison]: Doc/Comparison.html
[Enhancement]: Doc/Enhancement.html
[MSAG]: Doc/MSAG.html
[Submission]: Doc/Submission.html
[Validation]: Doc/Validation.html
[Topology Rules]: Doc/Topology.html
[Change Log]: ChangeLog.html
[Error Glossary]: Doc/ErrorGlossary.html
[Examples]: Doc/Examples.html
[Generate Fishbone Analysis]: Doc/FishboneAddressVerification.html
[1 Create Standard GDB]: Doc/Prep.html#1-create-standard-gdb
[2 Field Map Feature Class]: Doc/Prep.html#2-field-map-feature-class
[Calculate Null Values to `N`]: Doc/Enhancement.html#calculate-null-values-to-n
[Calculate `FullName` and `LgcyFulSt`]: Doc/Enhancement.html#calculate-fullname-and-lgcyfulst
[Calculate `RCLMatch` and `RCLSide`]: Doc/Enhancement.html#calculate-rclmatch-and-rclside
[Convert Type]: Doc/Enhancement.html#convert-type-legacy-or-next-gen
[Convert Direction]: Doc/Enhancement.html#convert-direction-legacy-or-next-gen
[next-gen fields]: <Doc/Enhancement.html#next-gen-fields>
[legacy fields]: <Doc/Enhancement.html#legacy-fields>
[Oklahoma Geographic Information Council's standards webpage]: https://okmaps.onenet.net/address_standards.htm
[Kansas NG911 Toolkit]: https://github.com/kansasgis/NG911
[API Doc/config_yaml.html]: <API Doc/config_yaml.html>
[API]: <API Doc/index.html>